/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.toy.TConfigurationManager;
import edu.princeton.toy.TExampleManager;
import edu.princeton.toy.TFrame;
import edu.princeton.toy.TImageManager;
import edu.princeton.toy.TOptionsFrame;
import edu.princeton.toy.TResourceLoader;
import edu.princeton.toy.TSplashWindow;
import java.awt.Image;
import java.io.File;
import java.io.Reader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class TMain {
    private static final TMain INSTANCE = new TMain();
    private Image frameIcon;
    private String version = "(Error)";
    private String buildDate = "(Error)";

    private TMain() {
    }

    public static void main(String[] arguments) {
        System.out.println("Visual X-TOY");
        try {
            StringBuffer buffer = new StringBuffer();
            Reader reader = TResourceLoader.getReader("version");
            int character = reader.read();
            while (character != 10 && character != -1) {
                buffer.append((char)character);
                character = reader.read();
            }
            if (character == 10) {
                TMain.INSTANCE.version = buffer.toString();
                character = reader.read();
                buffer.delete(0, buffer.length());
                while (character != 10 && character != -1) {
                    buffer.append((char)character);
                    character = reader.read();
                }
                if (character == 10) {
                    TMain.INSTANCE.buildDate = buffer.toString();
                    character = reader.read();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Version:       " + TMain.INSTANCE.version);
        System.out.println("Build Date:    " + TMain.INSTANCE.buildDate);
        System.out.println("OS Name:       " + System.getProperty("os.name"));
        System.out.println("User Home:     " + System.getProperty("user.home"));
        System.out.println("Class Version: " + System.getProperty("java.class.version"));
        System.out.println("JVM Version:   " + System.getProperty("java.version"));
        try {
            StringBuffer buffer1 = new StringBuffer("foo");
            StringBuffer buffer2 = new StringBuffer("bar");
            buffer1.append(buffer2);
        }
        catch (NoSuchMethodError e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "You are executing a version of Visual X-TOY that requires Java 1.4 or better,\nbut your version of java is " + System.getProperty("java.version") + ".\n" + "Please upgrade your JVM or use the Java 1.3 compatible version of Visual X-TOY.", "JVM Error", 0);
            System.exit(-1);
        }
        try {
            TImageManager.prepare((byte)0);
            TSplashWindow splashWindow = new TSplashWindow();
            splashWindow.setVisible(true);
            splashWindow.requestFocus();
            splashWindow.toFront();
            while (!TExampleManager.isReady() || !TConfigurationManager.isReady()) {
                Thread.sleep(500L);
            }
            TImageManager.prepare((byte)1);
            JFileChooser chooser = new JFileChooser();
            File currentDirectory = TOptionsFrame.getCurrentDirectory();
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            }
            chooser.rescanCurrentDirectory();
            String osName = System.getProperty("os.name").toLowerCase();
            TMain.INSTANCE.frameIcon = osName.indexOf("windows") != -1 ? TImageManager.getImage((byte)1, (short)0) : TImageManager.getImage((byte)1, (short)1);
            TFrame.createInitialFrame();
            splashWindow.setVisible(false);
            splashWindow.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static String getVersion() {
        return TMain.INSTANCE.version;
    }

    public static String getBuildDate() {
        return TMain.INSTANCE.buildDate;
    }

    public static Image getFrameIcon() {
        return TMain.INSTANCE.frameIcon;
    }
}

